;"Rave Start"
; by Krystone for 256b Atari XL/XE Compo
; Conceived in 2024, revisited in 2025
;
; This code uses LZSS Compressed SAP-R player by DMSC
;
; use MADS.exe to compile on Windows

    icl './equ.icl'

; Zero Page variables

    org $80

channelCopy     .ds 9
channelPosition .ds 9
bufferPointer   .ds 2
channelBits     .ds 1

song_ptr = getByte + 1

currentPos      .byte 0
bitData         .byte 1

; loading address

buffers	= $2000

;    .ds 256 * 9                     ; 2304 bytes
    dta 'Krystone2025'                  ; eye catcher, signature, or available bytes

.local songData                     ; LZSS compressed SAP-R (optimized)
    .he 7F 00 00 00 00 00 00 00 A9 54 DF A7 38 A7 47 A5 
    .he FE 5E A3 A3 8A FE 0C A2 10 02 A1 13 02 0A 12 0A 
    .he 42 35 44 5D 5F 0A 00 32 BD 5F 5F 60 AA 00 38 7D 
    .he 5F 22 1F 60 32 3D 5F AA 91 DF 5B 47
endAddress
.endl
   .print "endAddress=", songData.endAddress
   

;.local songData                     ; LZSS compressed SAP-R
    ;.he 7F 00 00 00 00 00 00 00 00 00 7F A9 54 A7 38 A7
    ;.he 47 A5 FF 5E 2B A3 A3 FF 0C A2 11 02 A1 14 02 0B 
    ;.he 12 12 0B 42 35 5E 5F 0B 00 32 BE 5F 60 60 AB 00 
    ;.he 89 38 7E 5F 20 60 32 3E 5F AB 91 E0 5B 47
;endAddress:
;.endl

.proc getByte
    lda songData+1
    inc song_ptr
    rts
.endp

.proc start ; start of the program
go:
    lda #9
    jsr openmode
    lsr 559                         ; Screen off, turn $22 into $11

    ldx #79                         ; x max
    stx COLCRS

; there's a small hack to draw outside to introduce more delay and faster blinking of screen colors

drawLine:
    ldx #40                         ; set previous to screen center
    stx OLDCOL
    ldy #190                        ; y bottom
    sty OLDROW
    dec color
    bne skipColor

skipColor:
    sta COLOR4
    ; dec COLCRS ; if you do it 2x, you'll get Atari logo on the screen :-)
    dec COLCRS
    jsr drawto
    bne drawLine

    lda #1
    sta bitData                    ; must contain 1, to be used by player later TODO: can I find 1 somewhere? :-)

    asl 559                        ; Screen on, turn $11 into $22

; Start the song

init_song:
    ldx #8
    ldy #0

; Read just init value and store into buffer and POKEY

clear:
    jsr getByte
    sta POKEY,x
    sty channelCopy,x

cbuf:
    sta buffers + 255
    inc cbuf + 2
    dex
    bpl clear

    ; Initialize buffer pointer

    sty bufferPointer

waitOneFrame:
    lda 20
    cmp 20
    beq *-2

playSongFrame:                      ; Play one frame of the song
    lda #>buffers
    sta bufferPointer+1
    lda songData
    sta channelBits
    ldx #8 

; Loop through all channels, one for each POKEY register

channelLoop:
    lsr channelBits
    bcs skipChannel                 ; C = 1 ? skip this channel
    lda channelCopy,x               ; Get status of this stream
    bne doByteCopy                  ; If > 0 we are copying bytes
    
; Decoding a new match/literal

    lsr bitData                     ; Get next bit
    bne got_bit
    jsr getByte                     ; Not enough bits, refill!
    ror                             ; Extract a new bit and add a 1 at the high bit (from C set above)
    sta bitData

got_bit:
    jsr getByte                     ; Always read a byte, it could mean "match size/offset" or "literal byte"
    bcs store                       ; Bit = 1 is "literal", bit = 0 is "match"
    sta channelPosition,x           ; Store
    jsr getByte
    sta channelCopy,x               ; Store and start copying first byte

doByteCopy:
    dec channelCopy,x               ; Decrease match length, increase match position
    inc channelPosition,x
    ldy channelPosition,x
    lda (bufferPointer),y           ; Now, read old data, jump to data store

store:
    ldy currentPos
    sta POKEY,x                     ; Store to output and buffer
    sta (bufferPointer),y
    ;lda songData+19,x

skipChannel:
    inc bufferPointer + 1           ; Increment channel buffer pointer
    dex
    bpl channelLoop                 ; Next channel
    inc currentPos

checkIfSongEnds:                    ; Check if song is ending, jump to the next frame
    adc #$58                        ; alter the colors
    sta COLOR4                      ; flash color
    ;lda song_ptr + 1
    ;cmp #>songData.endAddress
    lda song_ptr
    cmp #<songData.endAddress       ;Completely in the ZP
    bne waitOneFrame

    ;lda #0
    lda #%11100000
    sta AUDC1                       ; Silence please
    sta GPRIOR

    ;jmp $e474                      ; reset

    ; Color candidates for a pause: $7b, $9b is nice as well

ll: inx
    lda 20
    cmp 19
    beq *-2
    inc COLOR4
    jmp ll

.endp

    run start.go